////////////////////////////////////////////////////////////////////////////////
///////////////////////    v0.2 /////////////////////////
///                            : BlackID                                ///
///                        15.04.2013                         ///
///                       16.04.2013                        ///
///                                                                          ///
///                               :                                   ///
///                    BlackID -                        ///
///                             Zeex - ZCMD                                  ///
////////////////////////////////////////////////////////////////////////////////

#define FILTERSCRIPT

#include <a_samp>
#include <zcmd>

#define COLOR 0xD1BB00FF

new hiddencase;
new maximumprize;
new hided;
new hiddencasereward;
new minigamestarted;
new thecreator[MAX_PLAYERS];
new prizetimer;
new prizeCP;
new CPtimer;
new Float:PickupPos[3];

public OnFilterScriptInit()
{
	print("\n--------------------------------------");
	print(" Find the hidden briefcase minigame by BlackID");
	print("--------------------------------------\n");
	return 1;
}

public OnFilterScriptExit()
{
	DestroyPickup(hiddencase);
	DisablePlayerCheckpoint(prizeCP);
	return 1;
}

public OnPlayerPickUpPickup(playerid, pickupid)
{
	if(pickupid == hiddencase)
	{
	    if(minigamestarted == 1)
    	{
			if(thecreator[playerid] == 1)
			{
			    SendClientMessage(playerid, COLOR, "*     ,      .");
			    return 1;
			}
	    	GivePlayerMoney(playerid, hiddencasereward);
			new string[128];
			new name[MAX_PLAYER_NAME+1];
    		GetPlayerName(playerid, name, sizeof(name));
			format(string,sizeof(string),"* ,    .   $%d  .",hiddencasereward);
			SendClientMessage(playerid, COLOR, string);
			format(string,sizeof(string),"* %s   .     $%d.",name, hiddencasereward);
			SendClientMessageToAll(COLOR, string);
			SendClientMessageToAll(COLOR, "*      .");
			SendClientMessageToAll(COLOR, "* - .");
			DestroyPickup(hiddencase);
			KillTimer(prizetimer);
			new Float:Pos[3];
			GetPlayerPos(playerid, Pos[0], Pos[1], Pos[2]);
			for(new i=0; i<MAX_PLAYERS; i++)
			{
			    if(IsPlayerConnected(i))
			    {
					prizeCP = SetPlayerCheckpoint(i, PickupPos[0], PickupPos[1], PickupPos[2], 3.0);
					CPtimer = SetTimer("CPPtimer", 180000, false);
				}
			}
			return 1;
		}
		else if(minigamestarted == 0)
		{
		    SendClientMessage(playerid, COLOR, "*    ,     ,      -.");
		    return 1;
		}
	}
	return 1;
}

forward CPPtimer();
public CPPtimer()
{
	for(new i=0; i<MAX_PLAYERS; i++)
	{
	    if(IsPlayerConnected(i))
	    {
	        if(thecreator[i] == 1)
	        {
	            RemovePlayerMapIcon(i, 1);
			}
			DisablePlayerCheckpoint(i);
			KillTimer(CPtimer);
		}
	}
	return 1;
}

forward PrizeIncrease();
public PrizeIncrease()
{
 	new string[64];
	if(hiddencasereward >= 185000 && hiddencasereward < 200000)
	{
	    hiddencasereward += (maximumprize - hiddencasereward);
		format(string,sizeof(string),"*    : $%d.",hiddencasereward);
		SendClientMessageToAll(COLOR, string);
		KillTimer(prizetimer);
	    return 1;
	}
	hiddencasereward += 15000;
	format(string,sizeof(string),"*    : $%d.",hiddencasereward);
	SendClientMessageToAll(COLOR, string);
	return 1;
}

CMD:hidecase(playerid, params[])
{
	if(!IsPlayerAdmin(playerid)) return SendClientMessage(playerid, COLOR, "*     .");
	if(hided == 1) return SendClientMessage(playerid, COLOR, "*   .");
	new Float:X, Float:X2, Float: Y2, Float:Y, Float:Z;
	GetPlayerPos(playerid, X2, Y2, Z);
	GetXYInFrontOfPlayer(playerid, X, Y, 2);
	hiddencase = CreatePickup(1210,2,X,Y,Z,0);
	PickupPos[0] = X;
	PickupPos[1] = Y;
	PickupPos[2] = Z;
	thecreator[playerid] = 1;
	hided = 1;
	SetPlayerMapIcon(playerid, 1, X, Y, Z, 9, 0);
	SendClientMessage(playerid, COLOR, "*   .  /startminigame       -.");
	return 1;
}

CMD:startminigame(playerid, params[])
{
	new name[MAX_PLAYER_NAME+1], string[128];
    GetPlayerName(playerid, name, sizeof(name));
	if(!IsPlayerAdmin(playerid)) return SendClientMessage(playerid, COLOR, "*     -.");
	if(hided == 0) return SendClientMessage(playerid, COLOR, "*    .");
	if(hiddencasereward < 1) return SendClientMessage(playerid, COLOR, "* ,   ,    -.");
	if(minigamestarted == 1) return SendClientMessage(playerid, COLOR, "* -  .");
	format(string,sizeof(string),"*  %s  -   .   ,    $%d  .",name, hiddencasereward);
	minigamestarted = 1;
	prizetimer = SetTimer("PrizeIncrease", 180000, true);
	SendClientMessageToAll(COLOR, string);
	return 1;
}

CMD:stopminigame(playerid, params[])
{
	if(!IsPlayerAdmin(playerid)) return SendClientMessage(playerid, COLOR, "*     -.");
	if(minigamestarted == 0) return SendClientMessage(playerid, COLOR, "* - .");
	minigamestarted = 0;
	DestroyPickup(hiddencase);
	new string[128], name[MAX_PLAYER_NAME+1];
	GetPlayerName(playerid, name, sizeof(name));
	format(string,sizeof(string),"*  %s  -   .",name);
	SendClientMessageToAll(COLOR, string);
	return 1;
}

CMD:setprize(playerid, params[])
{
	new prize;
	if(!IsPlayerAdmin(playerid)) return SendClientMessage(playerid, COLOR, "*     -.");
	if(minigamestarted == 1) return SendClientMessage(playerid, COLOR, "* -  .");
	if(sscanf(params, "d", prize)) return SendClientMessage(playerid, COLOR, "* ,   .");
	new string[64];
	if(prize > maximumprize) return format(string,sizeof(string),"*      : $%d",maximumprize), SendClientMessage(playerid, COLOR, "*      : $%d");
	SendClientMessage(playerid, COLOR, "*      -.");
	hiddencasereward = prize;
	return 1;
}

CMD:setmaximumprize(playerid, params[])
{
	new prize;
	if(!IsPlayerAdmin(playerid)) return SendClientMessage(playerid, COLOR, "*     -.");
	if(minigamestarted == 1) return SendClientMessage(playerid, COLOR, "* -  .");
	if(sscanf(params, "d", prize)) return SendClientMessage(playerid, COLOR, "* ,   .");
	if(prize > 999999999) return SendClientMessage(playerid, COLOR, "*     $999,999,999.");
	maximumprize = prize;
	return 1;
}


GetXYInFrontOfPlayer(playerid, &Float:x, &Float:y, Float:distance)
{
    new Float:a;
    GetPlayerPos(playerid, x, y, a);
    GetPlayerFacingAngle(playerid, a);
    if (GetPlayerVehicleID(playerid))
    {
      GetVehicleZAngle(GetPlayerVehicleID(playerid), a);
    }
    x += (distance * floatsin(-a, degrees));
    y += (distance * floatcos(-a, degrees));
}

stock sscanf(string[], format[], {Float,_}:...)
{
	#if defined isnull
		if (isnull(string))
	#else
		if (string[0] == 0 || (string[0] == 1 && string[1] == 0))
	#endif
		{
			return format[0];
		}
	#pragma tabsize 4
	new
		formatPos = 0,
		stringPos = 0,
		paramPos = 2,
		paramCount = numargs(),
		delim = ' ';
	while (string[stringPos] && string[stringPos] <= ' ')
	{
		stringPos++;
	}
	while (paramPos < paramCount && string[stringPos])
	{
		switch (format[formatPos++])
		{
			case '\0':
			{
				return 0;
			}
			case 'i', 'd':
			{
				new
					neg = 1,
					num = 0,
					ch = string[stringPos];
				if (ch == '-')
				{
					neg = -1;
					ch = string[++stringPos];
				}
				do
				{
					stringPos++;
					if ('0' <= ch <= '9')
					{
						num = (num * 10) + (ch - '0');
					}
					else
					{
						return -1;
					}
				}
				while ((ch = string[stringPos]) > ' ' && ch != delim);
				setarg(paramPos, 0, num * neg);
			}
			case 'h', 'x':
			{
				new
					num = 0,
					ch = string[stringPos];
				do
				{
					stringPos++;
					switch (ch)
					{
						case 'x', 'X':
						{
							num = 0;
							continue;
						}
						case '0' .. '9':
						{
							num = (num << 4) | (ch - '0');
						}
						case 'a' .. 'f':
						{
							num = (num << 4) | (ch - ('a' - 10));
						}
						case 'A' .. 'F':
						{
							num = (num << 4) | (ch - ('A' - 10));
						}
						default:
						{
							return -1;
						}
					}
				}
				while ((ch = string[stringPos]) > ' ' && ch != delim);
				setarg(paramPos, 0, num);
			}
			case 'c':
			{
				setarg(paramPos, 0, string[stringPos++]);
			}
			case 'f':
			{

				new changestr[16], changepos = 0, strpos = stringPos;
				while(changepos < 16 && string[strpos] && string[strpos] != delim)
				{
					changestr[changepos++] = string[strpos++];
    				}
				changestr[changepos] = '\0';
				setarg(paramPos,0,_:floatstr(changestr));
			}
			case 'p':
			{
				delim = format[formatPos++];
				continue;
			}
			case '\'':
			{
				new
					end = formatPos - 1,
					ch;
				while ((ch = format[++end]) && ch != '\'') {}
				if (!ch)
				{
					return -1;
				}
				format[end] = '\0';
				if ((ch = strfind(string, format[formatPos], false, stringPos)) == -1)
				{
					if (format[end + 1])
					{
						return -1;
					}
					return 0;
				}
				format[end] = '\'';
				stringPos = ch + (end - formatPos);
				formatPos = end + 1;
			}
			case 'u':
			{
				new
					end = stringPos - 1,
					id = 0,
					bool:num = true,
					ch;
				while ((ch = string[++end]) && ch != delim)
				{
					if (num)
					{
						if ('0' <= ch <= '9')
						{
							id = (id * 10) + (ch - '0');
						}
						else
						{
							num = false;
						}
					}
				}
				if (num && IsPlayerConnected(id))
				{
					setarg(paramPos, 0, id);
				}
				else
				{
					#if !defined foreach
						#define foreach(%1,%2) for (new %2 = 0; %2 < MAX_PLAYERS; %2++) if (IsPlayerConnected(%2))
						#define __SSCANF_FOREACH__
					#endif
					string[end] = '\0';
					num = false;
					new
						name[MAX_PLAYER_NAME];
					id = end - stringPos;
					foreach (Player, playerid)
					{
						GetPlayerName(playerid, name, sizeof (name));
						if (!strcmp(name, string[stringPos], true, id))
						{
							setarg(paramPos, 0, playerid);
							num = true;
							break;
						}
					}
					if (!num)
					{
						setarg(paramPos, 0, INVALID_PLAYER_ID);
					}
					string[end] = ch;
					#if defined __SSCANF_FOREACH__
						#undef foreach
						#undef __SSCANF_FOREACH__
					#endif
				}
				stringPos = end;
			}
			case 's', 'z':
			{
				new
					i = 0,
					ch;
				if (format[formatPos])
				{
					while ((ch = string[stringPos++]) && ch != delim)
					{
						setarg(paramPos, i++, ch);
					}
					if (!i)
					{
						return -1;
					}
				}
				else
				{
					while ((ch = string[stringPos++]))
					{
						setarg(paramPos, i++, ch);
					}
				}
				stringPos--;
				setarg(paramPos, i, '\0');
			}
			default:
			{
				continue;
			}
		}
		while (string[stringPos] && string[stringPos] != delim && string[stringPos] > ' ')
		{
			stringPos++;
		}
		while (string[stringPos] && (string[stringPos] == delim || string[stringPos] <= ' '))
		{
			stringPos++;
		}
		paramPos++;
	}
	do
	{
		if ((delim = format[formatPos++]) > ' ')
		{
			if (delim == '\'')
			{
				while ((delim = format[formatPos++]) && delim != '\'') {}
			}
			else if (delim != 'z')
			{
				return delim;
			}
		}
	}
	while (delim > ' ');
	return 0;
}
